package gov.va.vinci.dart.db;

import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;
import java.util.Set;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestDataSourceDAO  extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {

		try {
			DartObjectFactory.getInstance().getDataSourceDAO().findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<DataSource> dataSourceList = DartObjectFactory.getInstance().getDataSourceDAO().listAll();
		 
		Assert.assertNotNull(dataSourceList);
		Assert.assertTrue(dataSourceList.size() > 0);
		 
	}
	
	@Test
	public void testThree() throws Exception {

		try {
			DartObjectFactory.getInstance().getDataSourceDAO().findById(-1);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}

		
		// find somebody to search for
		List<DataSource> dataSourceList = DartObjectFactory.getInstance().getDataSourceDAO().listAll();
		 
		Assert.assertNotNull(dataSourceList);
		Assert.assertTrue(dataSourceList.size() > 0);
		 
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(dataSourceList.get(0).getId());
		Assert.assertNotNull(ds);
		Assert.assertTrue(dataSourceList.get(0).equals(ds));
		
	}

	@Test
	public void testTwo() throws Exception {

		List<DataSource> dataSourceList = DartObjectFactory.getInstance().getDataSourceDAO().findByDocumentTemplateId(-1);
		Assert.assertNotNull(dataSourceList);
		Assert.assertEquals(dataSourceList.size(), 0);

		// find somebody to search for
		dataSourceList = DartObjectFactory.getInstance().getDataSourceDAO().listAll();
		 
		Assert.assertNotNull(dataSourceList);
		Assert.assertTrue(dataSourceList.size() > 0);
		 
		DataSource ds = dataSourceList.get(0);
		Assert.assertNotNull(ds);

		Set<DocumentTemplate> dtSet = ds.getDocumentTemplates();
		
		Assert.assertNotNull(dtSet);
		
		// there may not be any document templates associated with this data source.
		if (dtSet.size() > 0) {
			Assert.assertTrue(dtSet.size() > 0);
			 
			DocumentTemplate dt = (DocumentTemplate)dtSet.iterator().next();
			Assert.assertNotNull(dt);
			Assert.assertTrue(dt.getId() > 0);
			 
			List<DataSource> dsList = DartObjectFactory.getInstance().getDataSourceDAO().findByDocumentTemplateId(dt.getId());
			Assert.assertNotNull(dsList);
			Assert.assertTrue(dsList.size() > 0);
			
			for (DataSource ds2 : dsList) {
				Assert.assertTrue(ds2.getDocumentTemplates().contains(dt));
			}
		}
	}

}
